import UIKit

class ViewController: UIViewController, UICollisionBehaviorDelegate
{
    @IBOutlet weak var myBox: UILabel!
    @IBOutlet weak var barrier: UIView!
    var collisionCounter = 0
    
    var mainEngine : UIDynamicAnimator!
    var dynGravity : UIGravityBehavior!
    var collision : UICollisionBehavior!
    
    func collisionWithObjects ()
    {
        collision.addBoundary(withIdentifier: "barrierId" as NSCopying,
                              for: UIBezierPath(rect: barrier.frame))
        
        // optional
        let myBoxBehavior = UIDynamicItemBehavior(items: [myBox])
        myBoxBehavior.elasticity = 0.6
        mainEngine.addBehavior(myBoxBehavior)
    }
    
    
    
    override func touchesEnded(_ touches: Set<UITouch>,
                               with event: UIEvent?)
    {
        collisionCounter = 0
        myBox.center = CGPoint(x: 150, y: 100)
        mainEngine = UIDynamicAnimator(referenceView: self.view)
        dynGravity = UIGravityBehavior(items: [myBox])
        mainEngine.addBehavior(dynGravity)
        
        collision = UICollisionBehavior(items: [myBox])
        collision.collisionDelegate = self
        mainEngine.addBehavior(collision)
        collisionWithObjects()
        collisionWithView()
    }
    
   
    func collisionWithView ()
    {
        collision.translatesReferenceBoundsIntoBoundary = true
    }

    
    func collisionBehavior(_ behavior: UICollisionBehavior,
                           endedContactFor item: UIDynamicItem,
                           withBoundaryIdentifier identifier: NSCopying?)
    {
        let myLabel = item as! UILabel
        collisionCounter += 1
        myLabel.text = "\(collisionCounter)"
        
        if collisionCounter % 2 == 0
        {
            myLabel.backgroundColor = UIColor.purple
        }
        else
        {
            myLabel.backgroundColor = UIColor.cyan
        }
    }
    
}

